
// MyOSDPropertyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MyOSDProperty.h"
#include "MyOSDPropertyDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

VOID DumpDebugMessage( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC.OSD] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 9, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

BOOL on_process_preview_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CMyOSDPropertyDlg *  pMainDialog = (CMyOSDPropertyDlg *)(pUserData);

	if ( pMainDialog->m_pOSDAlphaBlender !=NULL )
	{
		AMESDK_OSD_SET_ALPHA_BLENDING( pMainDialog->m_pOSDAlphaBlender, PREVIEW_COLORSPACE, WIDTH, HEIGHT, pBuffer, nBufferLen );
	}

	return TRUE;
}

// CMyOSDPropertyDlg dialog

CMyOSDPropertyDlg::CMyOSDPropertyDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CMyOSDPropertyDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev = 0xFFFFFFFF;

	m_pOSDAlphaBlender = NULL;

	m_nVideoFrameWidth = 0;
	
	m_nVideoFrameHeight = 0;
	
	m_dVideoFrameRate = 0.0;
}

void CMyOSDPropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMyOSDPropertyDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_SET_OSD_TEXT, &CMyOSDPropertyDlg::OnBnClickedBtnSetOsdText)
	ON_BN_CLICKED(IDC_BTN_SET_OSD_PICTURE, &CMyOSDPropertyDlg::OnBnClickedBtnSetOsdPicture)
	ON_BN_CLICKED(IDC_BTN_SET_OSD_BUFFER, &CMyOSDPropertyDlg::OnBnClickedBtnSetOsdBuffer)	
	ON_BN_CLICKED(IDC_BTN_OK, &CMyOSDPropertyDlg::OnBnClickedBtnOk)
END_MESSAGE_MAP()


// CMyOSDPropertyDlg message handlers

BOOL CMyOSDPropertyDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	HWND hPreviewWindow = NULL;

	PF_BUFFER_CALLBACK pfVideoPreviewBC = NULL;

	pfVideoPreviewBC = on_process_preview_video_buffer;

	CWnd *pPreviewWnd = GetDlgItem( IDC_SC_PREVIEW );

	this->MoveWindow( 0, 0, 855, 520 );

	pPreviewWnd->MoveWindow( 5, 5, 704, 480 );

	CString strCaption = AMESDK_PRODUCT;

	strCaption += " OSD PROPERTY DEMO ";

	SetWindowText( strCaption );	

	m_hVideoDev = AMESDK_CREATE( AMESDK_PRODUCT, 0, 0, pPreviewWnd->GetSafeHwnd(), pfVideoPreviewBC, (PVOID)this );

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		return FALSE; 

		m_hVideoDev = 0xFFFFFFFF; 
	}

	// SETUP LIVE PATH PROPERTIES
	// 		
	AMESDK_SET_STANDARD( m_hVideoDev, NTSC );
	
	AMESDK_SET_FORMAT( m_hVideoDev, PREVIEW_COLORSPACE, WIDTH, HEIGHT, BIT_COUNT, FPS );

	AMESDK_SET_INPUT( m_hVideoDev, SDI_INPUT );		

	AMESDK_CREATE_OSD_ALPHA_BLENDER( &m_pOSDAlphaBlender );

	// AMESDK_OSD_SET_TEXT(  m_pOSDAlphaBlender, 0, 0, 0, 320, 240, "CH01", "Arial", 0, 48, 0xFFFF0000, 0xFFFFFFFF, 128, 0, 0, 0, 0, 0  );

	// AMESDK_OSD_SET_TEXT( m_pOSDAlphaBlender, 0, 100, 100, 0, 0, "yuan test", "Arial", 1, 72, 0xFFFF0000, 0xFFFFFFFF, 0xFFFF0000, 10, 255, 0, 0, 0);

	AMESDK_RUN( m_hVideoDev );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMyOSDPropertyDlg::OnDestroy()
{
	if ( m_pOSDAlphaBlender != NULL )
	{
		AMESDK_DESTROY_OSD_BLENDER( m_pOSDAlphaBlender );

		m_pOSDAlphaBlender = NULL;
	}

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_DESTROY( m_hVideoDev );
		
		m_hVideoDev = 0xFFFFFFFF; 
	}

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyOSDPropertyDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyOSDPropertyDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CMyOSDPropertyDlg::GetCurrentDeviceFormat( ULONG * pVideoWidth, ULONG * pVideoHeight, BOOL *  pVideoIsInterleaved, ULONG * pVideoFrameRate,  ULONG * pAudioChannels,  ULONG * pAudioBitsPerSample, ULONG * pAudioSampleFrequency )
{
	ULONG n_video_resolution_property = 0x00000000;

	ULONG n_video_framerate_property = 0x00000000;
	
	ULONG n_audio_sample_frequency_property = 0x00000000;
	
	if( m_hVideoDev == 0xFFFFFFFF ) { return FALSE; }
	
	ULONG n_standard = 0x00000000;
	
	ULONG n_status = 0x00000000;
	
	AMESDK_GET_LOCK( m_hVideoDev, &n_status );
	
	if( !(n_status & 0x00000001) ) { return FALSE; }

	AMESDK_GET_CUSTOM_PROPERTY( m_hVideoDev, 208, &n_video_framerate_property );

	AMESDK_GET_CUSTOM_PROPERTY( m_hVideoDev, 210, &n_video_resolution_property );

	AMESDK_GET_CUSTOM_PROPERTY( m_hVideoDev, 253, &n_audio_sample_frequency_property );

	ULONG cx = 0;

	ULONG cy = 0;

	BOOL interleaved = FALSE;

	cx = (n_video_resolution_property >> 16) & 0x0000FFFF;

	cy = (n_video_resolution_property >>  0) & 0x0000FFFF;

	if( (cx ==  640 && cy == 240 && n_video_framerate_property == 60) ||

		(cx ==  640 && cy == 288 && n_video_framerate_property == 50) ||

		(cx ==  704 && cy == 240 && n_video_framerate_property == 60) ||

		(cx ==  704 && cy == 288 && n_video_framerate_property == 50) ||

		(cx ==  720 && cy == 240 && n_video_framerate_property == 60) ||

		(cx ==  720 && cy == 288 && n_video_framerate_property == 50) ||

		(cx ==  768 && cy == 288 && n_video_framerate_property == 50) ||

		(cx == 1440 && cy == 540 && n_video_framerate_property == 60) ||

		(cx == 1440 && cy == 540 && n_video_framerate_property == 50) ||

		(cx == 1920 && cy == 540 && n_video_framerate_property == 60) ||

		(cx == 1920 && cy == 540 && n_video_framerate_property == 50) ) {

		interleaved = TRUE;

		cy = cy * 2;
	}
	else if( (cx == 1440 && cy == 240 && n_video_framerate_property == 60) ||

			 (cx == 1440 && cy == 288 && n_video_framerate_property == 50) ) {

		cx = cx / 2;
	}
	else {

		;
	}

	*pVideoWidth = cx;

	*pVideoHeight = cy;

	*pVideoIsInterleaved = interleaved;

	*pVideoFrameRate = n_video_framerate_property;

	*pAudioChannels = 2;
	
	*pAudioBitsPerSample = 16;

	*pAudioSampleFrequency = n_audio_sample_frequency_property;

	return true;
}

void CMyOSDPropertyDlg::OnBnClickedBtnSetOsdText()
{
	// TODO: Add your control notification handler code here

	m_DlgSetOSDText.m_pOSDAlphaBlender = m_pOSDAlphaBlender;

	if ( m_DlgSetOSDText.DoModal() == IDOK )
	{

	}
}


void CMyOSDPropertyDlg::OnBnClickedBtnSetOsdPicture()
{
	// TODO: Add your control notification handler code here

	m_DlgSetOSDPicture.m_pOSDAlphaBlender = m_pOSDAlphaBlender;

	if ( m_DlgSetOSDPicture.DoModal() == IDOK )
	{

	}
}


void CMyOSDPropertyDlg::OnBnClickedBtnSetOsdBuffer()
{
	// TODO: Add your control notification handler code here

	m_DlgSetOSDBuffer.m_pOSDAlphaBlender = m_pOSDAlphaBlender;

	if ( m_DlgSetOSDBuffer.DoModal() == IDOK )
	{

	}
}



void CMyOSDPropertyDlg::OnBnClickedBtnOk()
{
	// TODO: Add your control notification handler code here

	CDialogEx::OnOK();
}
